<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class Post extends Model 
{

    protected $table = 'posts';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('title', 'body', 'thumbnail');

    public function category()
    {
        return $this->belongsTo('App\Models\Category');
    }

    public function favouritedClients()
    {
        return $this->morphToMany('App\Models\Client', 'clientable');
    }

}